 

IF EXISTS (SELECT 1 FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_NF_SAI]'))
	DROP VIEW [DBO].[V_EST_NF_SAI]
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230627
'Job.................:  
'Nome................: [V_EST_NF_SAI]
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 27/06/2023
'Dt Ult Alteraco....: --
'Criado por..........: --
'Alterado por........: Marcos Barros
'=======================================================================================
*/

CREATE  VIEW [DBO].[V_EST_NF_SAI]

AS
	 SELECT
	        DBO.EST_NF_SAI_IT.CD_EMP
		  , DBO.EST_NF_SAI_IT.CD_FILIAL
		  , DBO.EST_NF_SAI_IT.CD_NF
		  , DBO.EST_NF_SAI.CD_NF_SERIE
		  , DBO.EST_NF_SAI.CD_PED
		  , DBO.EST_NF_SAI.CD_CLI
		  , ISNULL(V_GLB_PESSOA.RAZAO_SOCIAL_PESSOA, '') AS NM_DEST
		  , ISNULL(V_GLB_PESSOA.NOME_FANTASIA_PESSOA, '') AS NM_FANT
		  , ISNULL(V_GLB_PESSOA.CGC_CPF, '') AS CGC_CPF
		  , ISNULL(V_GLB_PESSOA.INSC_EST, '') AS INSC_EST
		  , ISNULL(V_GLB_PESSOA.INSC_MUNI, '') AS INSC_MUNI
		  , ISNULL(V_GLB_PESSOA.ENDERECO_PESSOA, '') AS ENDE
		  , ISNULL(V_GLB_PESSOA.NUMERO_ENDERECO_PESSOA, '') AS NUMERO
		  , ISNULL(V_GLB_PESSOA.BAIRRO_ENDERECO_PESSOA, '') AS BAIRRO
		  , ISNULL(V_GLB_PESSOA.CEP_ENDERECO_PESSOA, '') AS CEP
		  , ISNULL(V_GLB_PESSOA.TELEFONE_PESSOA, '') AS TEL
		  , ISNULL(V_GLB_PESSOA.DS_CID, '') AS DS_CID
		  , ISNULL(V_GLB_PESSOA.UF, '') AS UF
		  , ISNULL(V_GLB_PESSOA.CD_CID, 0) AS CD_CID
		  , ISNULL(V_GLB_PESSOA.COD_IBGE_MUNICIPIO, 0) AS COD_IBGE
		  , ISNULL(V_GLB_PESSOA.CONTRIBUINTE, 0) AS CONTRIBUINTE
		  , CASE
				WHEN GLB_MOV_OP.DEST_ORIG = 0 THEN X.CD_FILIAL
				WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN 0
				WHEN GLB_MOV_OP.DEST_ORIG = 2 THEN EST_NF_SAI.CD_CLI
			END AS CD_CLI_FILIAL
		  , DBO.EST_NF_SAI.NF_NF
		  , DBO.EST_NF_SAI.CD_VEND
		  , DBO.EST_NF_SAI.CD_COND_PGTO
		  , DBO.EST_NF_SAI_IT.DT_EMI_NF
		  ,CONVERT(VARCHAR(9), EST_NF_SAI.HR_EMI_NF,108) AS HR_EMI_NF
		  , DBO.EST_NF_SAI.VLR_NF
		  , DBO.EST_NF_SAI.VLR_TOT_PROD
		  , DBO.EST_NF_SAI.VLR_IPI
		  , DBO.EST_NF_SAI.VLR_ICMS
		  , DBO.EST_NF_SAI.VLR_FRETE
		  , 0 AS VLR_OUTRAS_DESP
		  , DBO.EST_NF_SAI.TP_FRETE
		  , DBO.EST_NF_SAI.VLR_DESC AS VLR_DESC_CORPO
		  , DBO.EST_NF_SAI.INF_DESCONTO
		  , DBO.EST_NF_SAI.NM_COMPRADOR
		  , DBO.EST_NF_SAI.STS_NF
		  , DBO.EST_NF_SAI.OBS1
		  , DBO.EST_NF_SAI.OBS2
		  , DBO.EST_NF_SAI.OBS3
		  , DBO.EST_NF_SAI.OBS4
		  , DBO.EST_NF_SAI.OBS5
		  , DBO.EST_NF_SAI.OBS6
		  , DBO.EST_NF_SAI.OBS7
		  , DBO.EST_NF_SAI.OBS8
		  , DBO.EST_NF_SAI.OBS9
		  , DBO.EST_NF_SAI.OBS10
		  , DBO.EST_NF_SAI.OBS11
		  , DBO.EST_NF_SAI.OBS12
		  , DBO.EST_NF_SAI.DS_TRANSP
		  , DBO.EST_NF_SAI.PLACA_VEIC
		  , DBO.EST_NF_SAI.PLACA_UF
		  , DBO.EST_NF_SAI.CGC_CPF_TRANSP
		  , DBO.EST_NF_SAI.ENDE_TRANSP
		  , DBO.EST_NF_SAI.DS_CID_TRANSP
		  , DBO.EST_NF_SAI.UF_TRANSP
		  , DBO.EST_NF_SAI.INSC_EST_TRANSP
		  , DBO.EST_NF_SAI.EMAIL_TRANSP
		  , DBO.EST_NF_SAI.QT_VOL
		  , DBO.EST_NF_SAI.ESP_VOL AS ESPCIE_VOL
		  , DBO.EST_NF_SAI.MC_VOL
		  , DBO.EST_NF_SAI.NR_VOL
		  , DBO.EST_NF_SAI.PESO_VOL AS PESO_BRT
		  , DBO.EST_NF_SAI.PESO_LIQ_VOL AS PES_LIQ
		  , DBO.EST_NF_SAI_IT.CD_PROD
		  , DBO.EST_PROD.DS_PROD         
		  , DBO.EST_NF_SAI_IT.VLR_IT
		  , DBO.EST_NF_SAI_IT.VLR_DESC_IT
		  , DBO.EST_NF_SAI_IT.QT_IT
		  , DBO.EST_NF_SAI_IT.VLR_ICMS_IT
		  , DBO.EST_NF_SAI_IT.ALIQ_ICMS
		  , DBO.EST_NF_SAI_IT.CD_TRIB
		  , DBO.EST_TRIB.CD_TRIB_FC
		  , DBO.EST_NF_SAI_IT.UN
		  , DBO.EST_NF_SAI_IT.PERC_IPI
		  , DBO.EST_NF_SAI_IT.VLR_CUSTO
		  , DBO.EST_NF_SAI_IT.VLR_BASE_SUBS
		  , DBO.EST_NF_SAI_IT.VLR_ICMS_SUBS
		  , DBO.EST_NF_SAI_IT.QT_EST_ANT
		  , DBO.EST_NF_SAI_IT.CD_NT_OP
		  , DBO.EST_NF_SAI_IT.VLR_BASE_ICMS_IT
          , DBO.EST_NF_SAI_IT.ICMS_DESONERADO_MOTIVO
		  , DBO.EST_NF_SAI_IT.VLR_PROD_PED
		  , CASE
				WHEN ISNULL(DBO.EST_NF_SAI.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN DBO.EST_NF_SAI_IT.VLR_TOT_IT
				ELSE DBO.EST_NF_SAI_IT.VLR_TOT_IT - EST_NF_SAI_IT.VLR_DESC_IT
			END AS VLR_TOT_IT
		  , DBO.EST_NF_SAI_IT.VLR_SUFRAMA
		  , DBO.EST_NF_SAI_IT.VLR_ISENTO
		  , DBO.EST_NF_SAI_IT.VLR_OUTROS
		  , DBO.EST_NF_SAI.CD_NT_MOV
		  , DBO.GLB_NT_OP.CD_NT_OP_FC
		  , DBO.GLB_MOV_OP.CD_MOV_OP
		  , DBO.GLB_MOV_OP.DS_MOV_OP
		  , DBO.GLB_MOV_OP.DS_MOV_OP_USUAL
		  , DBO.GLB_MOV_OP.TP_MOV_OP_TRANSA
		  , DBO.GLB_MOV_OP.TP_MOV
		  , DBO.GLB_MOV_OP.BX_EST
		  , DBO.EST_NF_SAI.DT_CAD
		  , DBO.EST_NF_SAI.CD_USU
		  , DBO.EST_NF_SERIE.SERIE
		  , DBO.EST_NF_SERIE.ESPC
		  , ISNULL(DBO.EST_NF_SERIE.MODELO, '') AS MODELO
		  , DBO.EST_NF_SAI.VLR_BASE_ICMS
		  , DBO.EST_NF_SAI.VLR_BASE_ICMS_SUBS AS VLR_BASE_SUBS_CAB
		  , DBO.EST_NF_SAI.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_CAB
		  , DBO.GLB_NT_OP.CD_CTB_CNT_RED
		  , DBO.GLB_NT_OP.CD_CTB_CNT
		  , DBO.GLB_MOV_OP.DEST_ORIG
		  , DBO.EST_NF_SAI_IT.CD_IT
		  , DBO.EST_NF_SAI_IT.PIS_COFINS
		  , DBO.GLB_MOV_OP.TP_ESTQ
		  , DBO.GLB_MOV_OP.ENVIO_OPERADOR_LOG
		  , DBO.GLB_MOV_OP.FLAG_RETORNO_OPERADOR_LOG
		  , DBO.GLB_MOV_OP.FLAG_ENTRADA_OPERADOR_LOG
		  , DBO.EST_NF_SAI.NR_SELO_SAIDA
		  , DBO.EST_NF_SAI.NR_FORMULARIO
		  , L.DS_SIGLA_LINHA
		  , DBO.EST_NF_SAI_IT.PERC_DESC_IT
		  , DBO.EST_NF_SAI.DT_ULT_ALT
		  , DBO.EST_TRIB.ICMS
		  , DBO.EST_TRIB.SUBS_TRIB
		  , DBO.EST_TRIB.ICMS_RD
		  , DBO.EST_TRIB.SUBS_TRIB_ANT
		  , DBO.EST_TRIB.ISENTO
		  , DBO.EST_TRIB.FLAG_OUTROS
		  , ISNULL(DBO.EST_TRIB.TRIB_FC_ELETRONICO, '') TRIB_FC_ELETRONICO
		  , EST_PROD.NR_NCM
		  , DBO.EST_NF_SAI_IT.LISTA_PROD
		  , ISNULL(ISNULL(CL.CD_FILIAL, FO.CD_FILIAL), 0) AS CD_FILIAL_CLI
		  , ISNULL(DBO.EST_NF_SAI.QT_CX_VOL, 0) AS QT_CX_VOL
		  , EST_PROD.CTR_LOTE
		  , ISNULL(EST_PROD.CONTROLE_SNGPC, 0) AS CONTROLE_SNGPC
		  , ISNULL(DBO.EST_NF_SAI_IT.VLR_BASE_PIS, 0) AS VLR_BASE_PIS
		  , ISNULL(DBO.EST_NF_SAI_IT.VLR_PIS, 0) AS VLR_PIS
		  , ISNULL(DBO.EST_NF_SAI_IT.VLR_BASE_COFINS, 0) AS VLR_BASE_COFINS
		  , ISNULL(DBO.EST_NF_SAI_IT.VLR_COFINS, 0) AS VLR_COFINS
		  , ISNULL(DBO.EST_NF_SAI.VLR_ISSQN, 0) AS VLR_ISSQN
		  , ISNULL(DBO.EST_NF_SAI.PERC_ISSQN, 0) AS PERC_ISSQN
		  , ISNULL(DBO.EST_NF_SAI.CD_TRANSP, 0) AS CD_TRANSP
		  , ISNULL(DBO.EST_NF_SAI.FLAG_IGNORAR_CONTROL, 0) AS FLAG_IGNORAR_CONTROL
		  , ISNULL(DBO.EST_NF_SAI.FLAG_NF_PROD_TOTAL_BRUTO, 0) AS FLAG_NF_PROD_TOTAL_BRUTO
		  , ISNULL(FLAG_MOV_OP_NFE_CPL, 0) AS FLAG_MOV_OP_NFE_CPL
		  , ISNULL(EST_NF_SAI_IT.PERC_ALIQ_COFINS, 0) AS PERC_ALIQ_COFINS
		  , ISNULL(EST_NF_SAI_IT.VLR_BASE_ICMS_RET, 0) AS VLR_BASE_ICMS_RET
		  , ISNULL(EST_NF_SAI_IT.VLR_ICMS_RET, 0) AS VLR_ICMS_RET
		  , ISNULL(EST_NF_SAI_IT.PERC_REDU_BASE_ICMS, 0) AS PERC_REDU_BASE_ICMS_IT
		  , ISNULL(EST_NF_SAI_IT.PERC_REDU_BASE_SUBS, 0) AS PERC_REDU_BASE_SUBS_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_PROD_FRETE, 0) AS VLR_PROD_FRETE
		  , ISNULL(EST_NF_SAI_IT.PERC_ALIQ_PIS, 0) AS PERC_ALIQ_PIS
		  , CASE
				WHEN ISNULL(DBO.EST_NF_SAI_IT.CD_SIT_OPERA_SIMPLES_NACIO, 0) = 0 THEN CASE
																						  WHEN ISNULL(EST_TRIB.TIPO_REGIME_EMPRESA, 0) = 1 THEN DBO.EST_TRIB.CD_TRIB_FC
																						  ELSE ISNULL(EST_NF_SAI_IT.CD_SIT_OPERA_SIMPLES_NACIO, 0)
																					  END
				ELSE ISNULL(EST_NF_SAI_IT.CD_SIT_OPERA_SIMPLES_NACIO, 0)
			END AS CD_SIT_OPERA_SIMPLES_NACIO
		  , ISNULL(EST_NF_SAI_IT.MODALI_BASE_ICMS_SUBST, 0) AS MODALI_BASE_ICMS_SUBST
		  , ISNULL(EST_NF_SAI_IT.MODALI_BASE_ICMS, 0) AS MODALI_BASE_ICMS
		  , ISNULL(EST_NF_SAI_IT.VLR_CRED_BASE_SN, 0) AS VLR_CRED_BASE_SN
		  , ISNULL(EST_NF_SAI_IT.VLR_CRED_ICMS_SN, 0) AS VLR_CRED_ICMS_SN
		  , ISNULL(EST_NF_SAI_IT.VLR_OUTROS_DESPESAS, 0) AS VLR_OUTROS_DESPESAS
		  , ISNULL(EST_NF_SAI.VLR_OUTROS, 0) AS VLR_OUTROS_DESPESAS_CAB
		  , FLAG_ICMS_SUBST_PAGO_ANTERIOR
		  , CASE
				WHEN ISNULL(EST_NF_SAI_IT.VLR_IPI_IT, 0) = 0 THEN CASE
																	  WHEN ISNULL(DBO.EST_NF_SAI.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN ROUND(ISNULL((EST_NF_SAI_IT.VLR_TOT_IT + EST_NF_SAI_IT.VLR_OUTROS_DESPESAS) * EST_NF_SAI_IT.PERC_IPI, 0) / 100, 2)
																	  ELSE ROUND(ISNULL((EST_NF_SAI_IT.VLR_TOT_IT - DBO.EST_NF_SAI_IT.VLR_DESC_IT + EST_NF_SAI_IT.VLR_OUTROS_DESPESAS) * EST_NF_SAI_IT.PERC_IPI, 0) / 100, 2)
																  END
				ELSE EST_NF_SAI_IT.VLR_IPI_IT
			END AS VLR_IPI_IT
		  , ISNULL(EST_NF_SAI.VLR_BASE_ICMS_RET, 0) AS VLR_BASE_ICMS_RET_CAB
		  , ISNULL(EST_NF_SAI.VLR_ICMS_RET, 0) AS VLR_ICMS_RET_CAB
		  , V_GLB_PESSOA.ENVIAR_XML_NFE
		  , V_GLB_PESSOA.EMAIL_PESSOA AS EMAIL
		  , ISNULL(EST_NF_SAI_IT.CST_PIS, 0) AS CST_PIS
		  , ISNULL(EST_NF_SAI_IT.CST_COFINS, 0) AS CST_COFINS
		  , ISNULL(EST_NF_SAI.NF_MANUAL, 0) AS NF_MANUAL
		  , ISNULL(GLB_MOV_OP.FLAG_NAO_TRIBUTAR_PIS_COFINS, 0) AS FLAG_NAO_TRIBUTAR_PIS_COFINS
		  , ISNULL(EST_NF_SAI_IT.ALIQ_ICMS_INTERNO, 0) AS ALIQ_ICMS_INTERNO
		  , EST_NF_SERIE.TP_SR_NFE
		  , ISNULL(EST_NF_SAI_IT.PERC_IVA, 0) AS PERC_IVA
		  , ISNULL(EST_NF_SAI_IT.VLR_CUSTO_MD, 0) AS VLR_CUSTO_MD
		  , EST_NF_SAI.VLR_ISENTAS
		  , EST_NF_SAI_IT.VLR_ISENTO AS VLR_ISENTAS_IT
		  , ISNULL(APLICATIVO, '') AS APLICATIVO
		  , ISNULL(VERSAO_APLICATIVO, '') AS VERSAO_APLICATIVO
		  , ISNULL(EST_NF_SAI_IT.PIS_COFINS_RECALCULADO, 0) AS PIS_COFINS_RECALCULADO
		  , ISNULL(EST_NF_SAI_IT.TIPO_TRIBUTACAO_PIS_COFINS, 0) AS TIPO_TRIBUTACAO_PIS_COFINS
		  , EST_NF_SAI.DT_CANCEL
		  , GLB_NT_OP.DS_NT_OP
		  , FL.FLAG_OPERADOR_LOG
		  , EST_PROD.CTR_PMC
		  , ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) AS FLAG_NAO_GERAR_ARQ_SPED
		  , ISNULL(EST_NF_SAI.XPED_NOTA_FISCAL, '') AS XPED_NOTA_FISCAL
		  , NFE.NR_AUTORIZADOR
		  , NFE.NR_PROTOCOLO
		  , NFE.VS_PROTOCOLO
		  , NFE.DT_RECBTO
		  , NFE.DG_VALIDADOR
		  , NFE.TP_AMB
		  , NFE.VS_APLIC
		  , NFE.REG_CONTG
		  , NFE_CANCEL.NR_PROTOCOLO AS NR_PROTOCOLO_CANCEL
		  , NFE_CANCEL.JUSTIFICATIVA AS JUSTIFICA_CANCEL
		  , EST_NF_SERIE.TP_SR_D
		  , EST_TRIB.TIPO_REGIME_EMPRESA
		  , ISNULL(EST_NF_SAI_IT.VLR_CUSTO_GERENCIAL_TRANSF, 0) AS VLR_CUSTO_GERENCIAL_TRANSF
		  , CASE
				WHEN FL.FLAG_FATURAMENTO_AUTOMATICO_HABILITADO = 0 THEN 'NAO'
				WHEN FL.FLAG_FATURAMENTO_AUTOMATICO_HABILITADO = 1 THEN 'SOMENTE PRE-FATURA'
				WHEN FL.FLAG_FATURAMENTO_AUTOMATICO_HABILITADO = 2 THEN 'TODOS OS PROCESSOS'
			END AS FLAG_FATURAMENTO_AUTOMATICO_HABILITADO
		  , ISNULL(NFE_DENEGADA.CD_NF, 0) AS NFE_DENEGADA
		  , ISNULL(EST_NF_SAI_IT.VLR_PMC, 0) AS VLR_PMC
		  , ISNULL(EST_NF_SAI_IT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO
		  , ISNULL(EST_NF_SAI.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO_CAB
		  , ISNULL(EST_TRIB.ORIGEM_PRODUTO, 0) AS ORIGEM_PRODUTO
		  , ISNULL(EST_NF_SAI_IT.PERC_FECOP, 0) AS PERC_FECOP
		  , ISNULL(EST_PROD.NR_CEST, '') AS NR_CEST
		  , GLB_USU.NM_USU
		  , ISNULL(EST_TRIB.ICMS_DIFERIDO, 0) AS ICMS_DIFERIDO
		  , ISNULL(EST_NF_SAI_IT.VLR_BASE_ICMS_OP, 0) AS VLR_BASE_ICMS_OP
		  , ISNULL(EST_NF_SAI_IT.VLR_ICMS_OP, 0) AS VLR_ICMS_OP
		  , ISNULL(EST_NF_SAI_IT.PERC_ICMS_OP, 0) AS PERC_ICMS_OP
		  , ISNULL(EST_NF_SAI_IT.PERC_DIFERIMENTO, 0) AS PERC_DIFERIMENTO
		  , ISNULL(EST_NF_SAI_IT.VLR_ICMS_DIFERIMENTO, 0) AS VLR_ICMS_DIFERIMENTO
		  , EST_NF_SAI.DT_HR_CAD
		  , ISNULL(EST_NF_SAI_IT.VLR_BASE_ICMS_LUCRO_REAL, 0) AS VLR_BASE_ICMS_LUCRO_REAL
		  , ISNULL(EST_NF_SAI_IT.PERC_ICMS_LUCRO_REAL, 0) AS PERC_ICMS_LUCRO_REAL
		  , ISNULL(EST_NF_SAI_IT.VLR_ICMS_LUCRO_REAL, 0) AS VLR_ICMS_LUCRO_REAL
		  , ISNULL(COD_MUNICIPIO_SINTEGRA, 0) AS COD_IBGE_MUNICIPIO_DESTINATARIO
		  , ISNULL(EST_NF_SAI.END_DESTINATARIO, '') END_DESTINATARIO
		  , ISNULL(EST_NF_SAI.NR_END_DESTINATARIO, '') NR_END_DESTINATARIO
		  , ISNULL(EST_NF_SAI.PONTO_REF_DESTINATARIO, '') PONTO_REF_DESTINATARIO
		  , ISNULL(EST_NF_SAI.BAIRRO_DESTINATARIO, '') BAIRRO_DESTINATARIO
		  , ISNULL(EST_NF_SAI.CEP_DESTINATARIO, '') CEP_DESTINATARIO
		  , ISNULL(EST_NF_SAI.CIDADE_DESTINATARIO, '') CIDADE_DESTINATARIO
		  , ISNULL(EST_NF_SAI.CNPJ_DESTINATARIO, '') CNPJ_DESTINATARIO
		  , ISNULL(EST_NF_SAI.INSC_ESTADUAL_DESTINATARIO, '') INSC_ESTADUAL_DESTINATARIO
		  , ISNULL(EST_NF_SAI.RZ_DESTINATARIO, '') RZ_DESTINATARIO
		  , ISNULL(EST_NF_SAI.UF_DESTINATARIO, '') UF_DESTINATARIO
		  , ISNULL(EST_NF_SAI.CD_CID_DESTINATARIO, '') CD_CID_DESTINATARIO
		  , ISNULL(EST_NF_SAI.TIPO_TRANSACAO, 0) TIPO_TRANSACAO
		  , ISNULL(EST_PROD.FLAG_PROD_KIT, 0) AS FLAG_PROD_KIT
		  , ISNULL(FL.TP_REGIME_APURAC_PIS_COFINS, '') TP_REGIME_APURAC_PIS_COFINS
		  , ISNULL(EST_NF_SAI.VLR_FECOP_ST, 0) AS VLR_FECOP_ST
		  , ISNULL(EST_NF_SAI.VLR_FECOP, 0) AS VLR_FECOP
		  , ISNULL(EST_NF_SAI.VLR_FECOP_RET, 0) AS VLR_FECOP_RET
		  , ISNULL(EST_NF_SAI_IT.PERC_FECOP_ST, 0) AS PERC_FECOP_ST_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_BASE_FECOP_ST, 0) AS VLR_BASE_FECOP_ST_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_FECOP_ST, 0) AS VLR_FECOP_ST_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_BASE_FECOP, 0) AS VLR_BASE_FECOP_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_FECOP, 0) AS VLR_FECOP_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_BASE_FECOP_RET, 0) AS VLR_BASE_FECOP_RET_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_FECOP_RET, 0) AS VLR_FECOP_RET_IT
		  , ISNULL(EST_NF_SAI_IT.PERC_FECOP_RET, 0) AS PERC_FECOP_RET_IT
		  , ISNULL(EST_NF_SAI_IT.NR_ITEM_XPED, 0) AS NR_ITEM_XPED_IT
		  , ISNULL(EST_NF_SAI_IT.ALIQUOTA_PST, 0) AS ALIQUOTA_PST_IT
		  , ISNULL(EST_NF_SAI_IT.VLR_BC_UF_DEST, 0) AS VLR_BC_UF_DEST_IT
		  , ISNULL(EST_NF_SAI_IT.PERC_ICMS_RET, 0) AS PERC_ICMS_RET          
		  , ISNULL (V_GLB_PESSOA.COMPLEMENTO_RESIDENCIAL,'') AS COMPLEMENTO_RESIDENCIAL
          , BN.CD_BENEF
		  , EST_NF_SAI.UUID
		  , ISNULL(EST_NF_SAI_IT.CD_BENEF,'') AS CD_BENEF_IT
          , ISNULL (EST_NF_SAI.FLAG_NAO_ABATER_ICMS_DESONERADO, 1) AS FLAG_NAO_ABATER_ICMS_DESONERADO
          , ISNULL (EST_NF_SAI_IT.GERAR_DIFAL, 0) AS GERAR_DIFAL
          , ISNULL (EST_NF_SAI_IT.PERC_ICMS_ORIGEM_DIFAL, 0)   AS PERC_ICMS_ORIGEM_DIFAL
          , ISNULL (EST_NF_SAI_IT.PERC_ICMS_DESTINO_DIFAL, 0)  AS PERC_ICMS_DESTINO_DIFAL
          , ISNULL (EST_NF_SAI_IT.BASE_ICMS_DESTINO_DIFAL, 0)  AS BASE_ICMS_DESTINO_DIFAL
          , ISNULL (EST_NF_SAI_IT.VALOR_ICMS_DESTINO_DIFAL, 0) AS VALOR_ICMS_DESTINO_DIFAL
          , ISNULL (EST_NF_SAI_IT.VLR_CUSTO_PROD_ORIG, 0)      AS VLR_CUSTO_PROD_ORIG
		  , ISNULL(GLB_MOV_OP.FLAG_DEVOLUCAO,0)				   AS FLAG_DEVOLUCAO
		  , FL.NUMERO 										   AS NUMERO_EMI
		  ,ISNULL(GLB_MOV_OP.FLAG_GERAR_ICMS_RETIDO_PARA_RESSARCIMENTO,0) AS FLAG_GERAR_ICMS_RETIDO_PARA_RESSARCIMENTO
		  ,ISNULL(EST_NF_SAI.DEST_CPF_CNPJ_ENTREGA,'')				AS DEST_CPF_CNPJ_ENTREGA
		  ,ISNULL(EST_NF_SAI.INSC_SUFRAMA,'') AS INSC_SUFRAMA
		  ,ISNULL(EST_NF_SAI_IT.ALIQ_EFET_ICMS,'') AS ALIQ_EFET_ICMS_IT
		  ,ISNULL(EST_NF_SAI_IT.PERC_EFET_RED_BASE_CALC,'') AS PERC_EFET_RED_BASE_CALC_IT
		  ,ISNULL(EST_NF_SAI_IT.VLR_EFET_BASE_ICMS,'') AS VLR_EFET_BASE_ICMS_IT
		  ,ISNULL(EST_NF_SAI_IT.VLR_EFET_ICMS,'') AS VLR_EFET_ICMS_IT
		  ,ISNULL(EST_NF_SAI.VLR_EFET_ICMS,'') AS VLR_EFET_ICMS_CAB
		  ,ISNULL(EST_NF_SAI.VLR_BASE_CALC_EFET,'') AS VLR_BASE_CALC_EFET_CAB
	 FROM
		DBO.EST_NF_SAI
		INNER JOIN DBO.EST_NF_SAI_IT ON DBO.EST_NF_SAI.CD_EMP = DBO.EST_NF_SAI_IT.CD_EMP
										AND DBO.EST_NF_SAI.CD_FILIAL = DBO.EST_NF_SAI_IT.CD_FILIAL
										AND DBO.EST_NF_SAI.CD_NF = DBO.EST_NF_SAI_IT.CD_NF
										AND DBO.EST_NF_SAI.DT_EMI_NF = DBO.EST_NF_SAI_IT.DT_EMI_NF
		INNER JOIN DBO.EST_PROD ON DBO.EST_NF_SAI_IT.CD_EMP = DBO.EST_PROD.CD_EMP
								AND DBO.EST_NF_SAI_IT.CD_PROD = DBO.EST_PROD.CD_PROD
		INNER JOIN DBO.GLB_NT_OP ON DBO.EST_NF_SAI_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
		LEFT JOIN DBO.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON EST_PROD.CD_EMP = ARV.CD_EMP
																AND EST_PROD.CD_PROD = ARV.CD_PROD
		LEFT JOIN DBO.EST_ARV_MERC_LINHA AS L ON ARV.CD_EMP = L.CD_EMP
												AND ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA
		INNER JOIN DBO.EST_TRIB ON DBO.EST_NF_SAI_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
		INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_SAI.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
		OUTER APPLY UFD_GLB_PESSOA(EST_NF_SAI.CD_CLI, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA
		LEFT JOIN PRC_FILIAL_RC_CLI X ON X.CD_EMP = EST_NF_SAI.CD_EMP
										AND X.CD_CLI = EST_NF_SAI.CD_CLI
		INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_SAI.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
									AND DBO.EST_NF_SAI.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE
		LEFT OUTER JOIN DBO.PRC_FILIAL_RC_CLI AS CL ON DBO.EST_NF_SAI.CD_EMP = CL.CD_EMP
													AND DBO.EST_NF_SAI.CD_CLI = CL.CD_CLI
													AND EST_NF_SAI.CD_FILIAL = CL.CD_FILIAL

		LEFT JOIN PRC_FILIAL_PG_FORN FO ON DBO.EST_NF_SAI.CD_EMP = FO.CD_EMP
		  								 AND DBO.EST_NF_SAI.CD_CLI = FO.CD_FORN
		INNER JOIN PRC_FILIAL FL ON DBO.EST_NF_SAI.CD_EMP = FL.CD_EMP
									AND DBO.EST_NF_SAI.CD_FILIAL = FL.CD_FILIAL

		LEFT JOIN EST_NF_SAI_NFE NFE ON DBO.EST_NF_SAI.CD_EMP = NFE.CD_EMP
										AND DBO.EST_NF_SAI.CD_FILIAL = NFE.CD_FILIAL
										AND DBO.EST_NF_SAI.CD_NF = NFE.CD_NF
                                         
		LEFT  JOIN  EST_PROD_COD_BENEF  BN  ON 
		BN.CD_EMP    =EST_PROD.CD_EMP
		AND BN.CD_PROD    =EST_PROD.CD_PROD
		AND BN.UF   =EST_NF_SAI.UF_EMITENTE
		AND BN.CD_BENEF = EST_NF_SAI_IT.CD_BENEF  -- CRITRIO ADICIONADO J QUE HJ O SISTEMA PERMITE CADASTRAR MAIS DE UM CD_BENEF POR UF.
                                        
		LEFT JOIN EST_NF_SAI_NFE_CANCEL NFE_CANCEL ON DBO.EST_NF_SAI.CD_EMP = NFE_CANCEL.CD_EMP
													AND DBO.EST_NF_SAI.CD_FILIAL = NFE_CANCEL.CD_FILIAL
													AND DBO.EST_NF_SAI.CD_NF = NFE_CANCEL.CD_NF
		LEFT JOIN EST_NF_SAI_DENEGADA NFE_DENEGADA ON DBO.EST_NF_SAI.CD_EMP = NFE_DENEGADA.CD_EMP
													AND DBO.EST_NF_SAI.CD_FILIAL = NFE_DENEGADA.CD_FILIAL
													AND DBO.EST_NF_SAI.CD_NF = NFE_DENEGADA.CD_NF
		INNER JOIN GLB_USU ON EST_NF_SAI.CD_USU = GLB_USU.CD_USU
		LEFT JOIN GLB_CID ON EST_NF_SAI.CD_CID_DESTINATARIO = GLB_CID.CD_CID
		LEFT OUTER JOIN GLB_CID_GLB_MUNICIPIO ON GLB_CID.CD_CID = GLB_CID_GLB_MUNICIPIO.CD_CID
		LEFT OUTER JOIN GLB_MUNICIPIO ON GLB_CID_GLB_MUNICIPIO.CD_MUNICIPIO = GLB_MUNICIPIO.CD_MUNICIPIO;
